#!/bin/bash

echo "alias dir='ls -la --color=auto'" > /root/.bashrc

/sbin/syslogd

####################################
##### For Rocky Linux
#if [ "$1" != "daemon" ]; then
#	$0 daemon &
#	exec /usr/sbin/init
#fi
#sleep 1
####################################

####################################
##### For Alpine Linux
## Needed because bondix installer script calls systemctl
## and checks return value
cat > /usr/bin/systemctl <<EOF
#!/bin/sh
/bin/false
EOF
chmod 755 /usr/bin/systemctl
####################################

##
## The order of the network interfaces is not always the same.
## So we have to do a workaround to identify them.
##
extif=$(ip -o addr | awk '/10\.10\.3.\./{print $2}')
intif=$(ip -o addr | awk '/172\.16\.4\./{print $2}')

intip=$(ip -o addr | awk '/172\.16\.4\...\//{sub(/\/.*/,"",$4);print $4}')

if [ "$(hostname)" = "bondix1" ]; then
	ip addr flush ${extif}
	ip addr add 10.10.34.2/24 dev ${extif}
fi
if [ "$(hostname)" = "bondix2" ]; then
	ip addr flush ${extif}
	ip addr add 10.10.34.3/24 dev ${extif}
fi

##============
## Bondix
##============

##
## Download Bondix Server
##
if [ ! -e bondix.sh ]; then
	echo "**** Fetching Bondix server ****"
	curl -s -o /root/bondix.sh \
			 https://releases.bondix.dev/endpoint/install-bondix-server.sh
fi
chmod 755 bondix.sh
sed -i -e'/set -e/d' -e'/^LANIP=/i\exit' bondix.sh

##
## Bondix server: bind to the virtual VRRP address
##
sed -i -e"s/<IPADDR>/10.10.34.9/" /etc/bondixserver.json

hostname=$(hostname)
virt=$((17+${hostname#bondix}))
sed -i -e"s/<VIRTUAL>/169.254.1${virt}.1/" /etc/bondixserver.json
sed -i -e"s/<INTIP>/${intip}/" /etc/bondixserver.json

##
## Install Bondix server
##
echo "**** Installing Bondix server ****"
/root/bondix.sh </dev/null

rm -f /opt/bondix/server/scripts/tunnel-*connect.sh

##
## Allows bondixserver to bind to the VRRP address,
## even if the system does not hold it. 
##
echo 1 > /proc/sys/net/ipv4/ip_nonlocal_bind

##
## Disable NAT in bondix server
##
sed -i -e'/if.*-t nat/,/fi/s/^\([ \t]*\).*$/\1:/' /opt/bondix/server/scripts/interface-start.sh
#mv /opt/bondix/server/bondixserver /opt/bondix/server/bondixserver-orig
#cp -a /tmp/shared/bondixserver2 /opt/bondix/server/bondixserver

##
## Finally start bondix server
##
/root/start.sh

##============
## VRRP
##============

##
## Some routes that are necessary for the system to work
##
ip route del default
ip route add default via 10.10.34.1
ip route add 172.16.0.0/12 via 172.16.4.1
#ip route add 172.20.1.0/24 via 172.16.4.1
#ip route add 10.8.0.0/16 via 10.10.34.1
iptables -P FORWARD DROP
iptables -A FORWARD -m state --state ESTABLISHED,RELATED -j ACCEPT
iptables -A FORWARD -i ${intif} -o bondix0 -j ACCEPT
iptables -A FORWARD -i bondix0 -o ${intif} -j ACCEPT

conf=/etc/keepalived/keepalived.conf
sed -i -e"s/<EXTIF>/${extif}/g" -e"s/<INTIF>/${intif}/g" ${conf}

if [ "`hostname`" = "bondix1" ]; then
	#ip route add 192.168.0.0/16 via 172.16.4.12
	#ip route add 192.168.0.0/16 via 10.10.34.3
	#ip route add 172.16.0.0/16 via 10.10.34.3
	sed -i -e"s/<STATE>/MASTER/" -e"s/<PRIO>/102/" -e"s/<MYIP>/2/" \
			-e"s/<PEERIP>/3/" ${conf}
else
	#ip route add 192.168.0.0/16 via 172.16.4.11
	#ip route add 192.168.0.0/16 via 10.10.34.2
	#ip route add 172.16.0.0/16 via 10.10.34.2
	sed -i -e"s/<STATE>/BACKUP/" -e"s/<PRIO>/101/" -e"s/<MYIP>/3/" \
			-e"s/<PEERIP>/2/" ${conf}
fi

##### Alpine Linux
adduser -D vrrp
##### Rocky Linux
#adduser vrrp
####o#

mkdir -p /var/run/keepalived
chown vrrp /var/run/keepalived
#mkfifo /var/run/keepalived/fifo_root
#chown vrrp /var/run/keepalived/fifo_root
/usr/sbin/keepalived -l -f ${conf}
#/etc/keepalived/scripts/notify_vrrp.sh

##
## Done
##

## Bondix somehow sets this to 0600...
chmod 644 /var/run/bondixserver.pid

####################################
##### For Alpine Linux
#echo "**** Running Busy Wait ****"
mkfifo /tmp/waitf
while true; do
	read a </tmp/waitf
done
####################################
