#!/bin/bash

echo "alias dir='ls -la --color=auto'" > /root/.bashrc

/sbin/syslogd

##
## The order of the network interfaces is not always the same
## So we have to do a workaround to identify them.
##
extif=$(ip -o addr | awk '/10\.8\.9\./{print $2}')
intif=$(ip -o addr | awk '/192\.168\.10/{print $2}')

##
## Download Bondix Client
##
if [ ! -e /root/bondix.tgz ]; then
	echo "**** Fetching Bondix client ****"
	echo curl -s -o /root/bondix.tgz \
		https://releases.bondix.dev/files/bondixclient-1.25.7-x86_64.tar.gz
fi

##
## Install Bondix client
##
echo "**** Installing Bondix client ****"
tar x -o -C /opt/ -f /root/bondix.tgz

##
## override default route to bridge interface
##
ip route del default
ip route add default via 10.8.9.1
#ip route add 0.0.0.0/1 via 10.8.9.1
#ip route add 128.0.0.0/1 via 10.8.9.1
iptables -A POSTROUTING -t nat -o ${extif} -j MASQUERADE

##
## Start Bondix client
##
#ip=$(ip addr | awk '/^[0-9]/{a=0}/^[0-9].*eth0/{a=1}a&&/inet/{print $2}')
ip=$(ip -o addr | awk "/${intif}/{print \$4}")
ipbase=${ip%.*}
hostname=$(hostname)
sed -i -e"s/<IPBASE>/${ipbase}/" /etc/bondixclient.json
sed -i -e"s/<EXTIF>/${extif}/" /etc/bondixclient.json
sed -i -e"s/<ID>/${hostname,,}/" /etc/bondixclient.json
sed -i -e'/route/i\test "$1" = "0.0.0.0/1" && exit' /opt/client/scripts/tunnel-addroute.sh
sed -i -e'/route/i\test "$1" = "128.0.0.0/1" && exit' /opt/client/scripts/tunnel-addroute.sh

mkdir -p /etc/bondixclient.d
ln -s /opt/client/scripts /etc/bondixclient.d/hooks
/opt/client/bondixclient --nopid --flags useMMSG encryption logSSLErrors

#echo "**** Running Busy Wait ****"
mkfifo /tmp/waitf
while true; do
	read a </tmp/waitf
done

