#!/bin/bash

##
## Idea of this script:
## It gets called when keepalived changes state.
## If the state changes to FAULT, tell the bondix server to
## kick all clients out, so they try to reconnect immediately
## to the new server.
## Unfortunately, this does not work:
## - When this script is called, the virtual IPs have already been removed
## - Bondix, which uses the VIP, can no longer communicate
## - The Bondix clients never get kicked out
## - Due to the missing IP address, kicking takes way too long
##

fifo="$1"
logger -t NFYFI "Notify fifo script: fifo = ${fifo}, id = $(id)"
if [ ! -p ${fifo} ]; then
	logger -t NFYFI "Error: fifo ${fifo} does not exist"
	exit
fi

while read line; do
	IFS=' ' read -r t n s p <<< "${line}"
	logger -t NFYFI "Event: type=${t}, name=${n}, state=${s}, prio=${p}"
	## Debug: show all current IP addresses
	## This shows that the VIP is already gone.
	#ip -o a | while read line; do logger -t NFYFI "ip addr: $line"; done
	
	## Since kicking does not work, we skip it.
	## The code below is left as reference.
	continue

	if [ "${t}" = "INSTANCE" -a "${n//\"/}" = "VI_ext" -a "${s}" = "FAULT" ]; then
		logger -t NFYFI "Telling Bondix to kick clients"
		l=$(/opt/bondix/server/bxutil list | awk '
			/^ / { if ($NF > 0 ) print $1 " ";}')
		for i in ${l}; do
			logger -t NFYFI "   Kicking tunnel $i"
			/opt/bondix/server/bxutil delete $i
		done
	fi
done <${fifo}

