#!/bin/bash

## Image and container name
INAME=agw-img
CNAME=agw-cont

## Host and container ports
HOST_TCPPORT=50024
CONT_TCPPORT=50024
HOST_TLSPORT=50025
CONT_TLSPORT=50025
## Admin Port
HOST_ADMINPORT=6262
CONT_ADMINPORT=6262

## Log files
buildlog=docker-build.log
logpath=logs

test -d ${logpath} || mkdir -p ${logpath}

## Check whether container exists already
id=$(docker container list -qa -f name=${CNAME})

if [ "${id}" = "" ]; then
	## No container yet, so build and run
	echo -n "Building container ... "
	docker build --tag ${INAME} . >${buildlog}
	echo "done"
	echo -n "Starting container ... "
	docker run --detach --name ${CNAME} \
		-p ${HOST_TCPPORT}:${CONT_TCPPORT} \
		-p ${HOST_TLSPORT}:${CONT_TLSPORT} \
		-p 127.0.0.1:${HOST_ADMINPORT}:${CONT_ADMINPORT} \
		-v $(pwd)/${logpath}/:/var/log/:Z \
		${INAME}
else
	## Yes, container exists. So we just start it...
	echo -n "Starting container ... "
	docker container start ${id}
fi

echo "done"

